<?php
/**
 * Webhook Handler
 */

if (!defined('ABSPATH')) {
    exit;
}

class SEO_Tool_Webhook {
    /**
     * Send webhook
     */
    public function send($event, $data) {
        $webhook_url = get_option('seo_tool_webhook_url');
        
        if (!$webhook_url) {
            return;
        }
        
        $payload = [
            'event' => $event,
            'timestamp' => current_time('c'),
            'data' => $data,
        ];
        
        wp_remote_post($webhook_url, [
            'body' => json_encode($payload),
            'headers' => [
                'Content-Type' => 'application/json',
                'X-WordPress-Site' => home_url(),
            ],
            'timeout' => 5,
            'blocking' => false, // Don't wait for response
        ]);
    }
}

